// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Search functions for Tsc.
//..........................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include "Tscmsg.h"
#include <htmlhelp.h>

extern	HWND		hMainWindow;
extern	LPTSTR		lpszNA;

// Determine if a file can be searched in memory or on disk and
// call the appropriate function. Performs a binary search.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//..............................................................
__int64 SearchMyFileBinary(LPBYTE lpFileName, LPBYTE lpSearchString,
						   DWORD dwSizeOfString, HANDLE hFile, DWORD dwHeaderBytes,
						   LPSEARCH_TEMPLATE lpSearchParameters)						   
{
	ULARGE_INTEGER	li;
	LARGE_INTEGER	liHdrBytes;
	DWORD			dwNumberOfRecords;
	DWORD			dwFileSize;
	LPBYTE			lpFileBuffer;

	liHdrBytes.QuadPart = 0;
	liHdrBytes.LowPart = dwHeaderBytes;

	// Get the file size and return if we had an error.
	//.................................................
	li.QuadPart = GetMyFileSize(lpFileName,hFile);
	if (li.QuadPart == -1)
	{
		goto SearchBEnd;
	}
	// We only handle file sizes up to 4 Gigabytes long.
	//..................................................
	if (li.QuadPart > 0xffffffff)
	{
		MessageBoxProc(hMainWindow,IDS_PROGRAMLIMIT,IDS_FILETOOBIG,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		li.QuadPart = -1;
		goto SearchBEnd;
	}
	// Determine the size of the file minus the header bytes and then
	// calculate the number of records in the file.
	//...............................................................
	dwFileSize = (li.LowPart - dwHeaderBytes);
	dwNumberOfRecords = (dwFileSize/lpSearchParameters->SIZE_RECORD);

	// Position the file pointer to point to the first record
	// in the file.
	//.......................................................
	li.QuadPart = SetMyFilePointer(lpFileName,hFile,liHdrBytes.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto SearchBEnd;
	}
	// Allocate the memory for the file.
	//..................................
	lpFileBuffer = GlobalAlloc(GPTR,dwFileSize);

	// If the error is other than not enough memory display an error
	// message and exit.
	//..............................................................
	if (!lpFileBuffer)
	{
		if (GetLastError() != ERROR_NOT_ENOUGH_MEMORY)
		{
			li.QuadPart = -1;
			ErrorProcedure((LPTSTR) lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
			goto SearchBEnd;
		}
		else
		{
			// Not enough memory to search the file in memory so 
			// search it on disk.
			//.....................................................
			li.QuadPart  = SearchFileBinaryOnDisk(lpFileName,lpSearchString,
												  dwSizeOfString,hFile,dwHeaderBytes,
												  lpSearchParameters,dwNumberOfRecords);
		}
	}
	else
	{
		// We have enough memory to search the file in memory.
		//....................................................
		li.QuadPart  = SearchFileBinaryInMemory(lpFileName,lpSearchString,
												dwSizeOfString,hFile,dwHeaderBytes,
												lpSearchParameters,dwFileSize,
												dwNumberOfRecords,lpFileBuffer);
		DeallocateMemory(lpFileBuffer);
	}

	SearchBEnd:
	return(li.QuadPart);
}


// Perform a binary search on a structured file to find the first
// match for the search string.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//...............................................................
__int64 SearchFileBinaryInMemory(LPBYTE lpFileName, LPBYTE lpSearchString,
							     DWORD dwSizeOfString, HANDLE hFile, DWORD dwHeaderBytes,
							     LPSEARCH_TEMPLATE lpSearchParameters, DWORD dwFileSize,
								 DWORD dwRecordCount, LPBYTE lpTable)
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liHdrBytes;
	BOOL			bResult;
	DWORD			dwBytesRead;

	li.QuadPart = -1;
	liHdrBytes.QuadPart = 0;
	liHdrBytes.LowPart = dwHeaderBytes;

	// Read the file into memory. It is already positioned after any
	// header bytes in the file.
	//..............................................................
	bResult = ReadMyFile(lpFileName,hFile,lpTable,dwFileSize,&dwBytesRead,
						 NULL);
	if (!bResult)
	{
		goto SearchInMemEnd;
	}
	// Search for the first occurance of the passed string in the
	// table in extended memory.
	//...........................................................
	li.QuadPart = SearchTableBinaryInMemory(lpSearchString,dwSizeOfString,
											lpTable,lpSearchParameters,dwRecordCount);
	if (li.LowPart == TRUE)
	{
		li.HighPart += dwHeaderBytes;
	}
	
	SearchInMemEnd:
	return(li.QuadPart);
}

// Perform a binary search on a structured table of data in memory
// to find the first match for the search string.
//
// Returns: LowPart of large integer = TRUE if match found and
//          HighPart = position in table where the match was found.
//          Large integer = FALSE if no match found.
//.................................................................
__int64 SearchTableBinaryInMemory(LPBYTE lpSearchString, DWORD dwSizeOfString, LPBYTE lpTable,
								  LPSEARCH_TEMPLATE lpSearchParameters, DWORD dwRecordCount)
{
	LARGE_INTEGER	li;
	DWORD			dwHighCount;
	DWORD			dwLowCount;
	DWORD			dwCenterPosition;
	DWORD			dwCenterCount;
	BYTE			Signed;
	BYTE			Above;

	__asm
	{
		// Set the HighCount and LowCount for the table.
		//..............................................
		mov		dwLowCount,0
		mov		eax,dwRecordCount
		dec		eax				// Make zero based.
		mov		dwHighCount,eax
	}
	while(TRUE)
	{
		__asm
		{
			// CenterPosition = ((HighCount+LowCount)/2)*Record Size
			//......................................................
			mov		edx,lpSearchParameters
			push	edx
			mov		eax,dwHighCount
			add		eax,dwLowCount
			shr		eax,1
			mov		dwCenterCount,eax
			mov		ecx,dword ptr [edx].SIZE_RECORD
			mul		ecx
			mov		dwCenterPosition,eax
			pop		edx

			// Compare search field in the record with the 
			// search string.
			//............................................
			mov		esi,lpSearchString
			mov		edi,lpTable

			// Point to the record in the table to compare against.
			//.....................................................
			add		edi,dwCenterPosition

			// Point to the search field in the record to compare.
			//....................................................
			add		edi,dword ptr [edx].SEARCH_OFFSET

			// Use the size of the search string for the comparison.
			// This allows us to search with partial strings.
			//......................................................
			mov		ecx,dwSizeOfString
			cmp		ecx,dword ptr [edx].SEARCH_SIZE
			jbe		L1
			mov		ecx,dword ptr [edx].SEARCH_SIZE

			// See if the search fields are signed or not.
			//............................................
		L1:	btr		dword ptr [edx].TYPE_SEARCH,7
			setc	Signed

			// Set the direction for the comparison.
			//......................................
			cmp		dword ptr [edx].SEARCH_DIRECTION,BACKWARD
			jne		L2
			std
		L2:	cmp		dword ptr [edx].TYPE_SEARCH,0
			jne		L3
			repe	cmpsb
			jmp		L5
		L3:	cmp		dword ptr [edx].TYPE_SEARCH,1
			jne		L4
			repe	cmpsw
			jmp		L5
		L4:	cmp		dword ptr [edx].TYPE_SEARCH,2
			jne		L5
			repe	cmpsd
		L5:	cld			// Make sure.

			// Set the results according to the the type of comparison.
			//.........................................................
			pushfd
			cmp		Signed,1
			je		L6
			popfd
			seta	Above
			jmp		L7
		L6:	popfd
			setg	Above

			// Reset the signed field in the TYPE_SEARCH parameter
			// for the next record.
			//....................................................
			bts		dword ptr [edx].TYPE_SEARCH,7

			// Break if we have a match.
			//..........................
		L7:	je		HaveAMatch

			// We did not have a match. Adjust the HighCount or
			// LowCount accordingly.
			//.................................................
			mov		eax,dwCenterCount
			cmp		Above,0
			je		L9
			inc		eax
			mov		dwLowCount,eax
			cmp		eax,dwHighCount
			jbe		L8
			mov		li.LowPart,0
			mov		li.HighPart,0
			jmp		SearchEnd
		L8:	jmp		L11
		L9:	sub		eax,1
			mov		dwHighCount,eax
			jc		L10
			cmp		eax,dwLowCount
			jae		L11
	   L10:	mov		li.LowPart,0
			mov		li.HighPart,0
			jmp		SearchEnd
	   L11:
		}	// __asm
	}	// while(TRUE)
	HaveAMatch:

	// We had a match. Now look for the first occurance of the
	// string in the table.
	//........................................................
	while(TRUE)
	{
		__asm
		{
			mov		edx,lpSearchParameters
			mov		eax,dword ptr [edx].SIZE_RECORD
			sub		dwCenterPosition,eax
			jc		LastMatch

			// Compare the search field in the record with the
			// search string.
			//................................................
			mov		esi,lpSearchString
			mov		edi,lpTable

			// Point to the record in the table to compare against.
			//.....................................................
			add		edi,dwCenterPosition

			// Point to the search field in the record to compare.
			//....................................................
			add		edi,dword ptr [edx].SEARCH_OFFSET

			// Use the size of the string for the comparison. This
			// allows us to search with partial strings.
			//....................................................
			mov		ecx,dwSizeOfString
			cmp		ecx,dword ptr [edx].SEARCH_SIZE
			jbe		L12
			mov		ecx,dword ptr [edx].SEARCH_SIZE

			// See if the search fields are signed or not.
			//............................................
	   L12:	btr		dword ptr [edx].TYPE_SEARCH,7
			setc	Signed

			// Set the direction for the comparison.
			//......................................
			cmp		dword ptr [edx].SEARCH_DIRECTION,BACKWARD
			jne		L13
			std
	   L13:	cmp		dword ptr [edx].TYPE_SEARCH,0
			jne		L14
			repe	cmpsb
			jmp		L16
	   L14:	cmp		dword ptr [edx].TYPE_SEARCH,1
			jne		L15
			repe	cmpsw
			jmp		L16
	   L15:	cmp		dword ptr [edx].TYPE_SEARCH,2
			jne		L16
			repe	cmpsd
	   L16:	cld
			
			// If this record did not match, or no more records to
			// match against, the previous record is our first
			// match. 
			//.....................................................
		LastMatch:
			jz		L17
			mov		eax,dwCenterPosition
			add		eax,dword ptr [edx].SIZE_RECORD
			mov		li.LowPart,TRUE
			mov		li.HighPart,eax
			jmp		SearchEnd

			// Reset the signed bit if required.
			//..................................
	   L17:	cmp		Signed,0
			je		L18
			bts		dword ptr [edx].TYPE_SEARCH,7
	   L18:
		}	// __asm
	}	// while(TRUE)

	SearchEnd:
	return(li.QuadPart);
}

// Perform a binary search on a structured file to find the first
// match for the search string.
//
// Returns: Large integer = -1 if an error occured.
//          LowPart = TRUE if a match is found and Highpart =
//          position in file where the match was found.
//          Large integer = FALSE if no match found.
//...............................................................
__int64 SearchFileBinaryOnDisk(LPBYTE lpFileName, LPBYTE lpSearchString, DWORD dwSizeOfString,
							   HANDLE hFile, DWORD dwHeaderBytes,
							   LPSEARCH_TEMPLATE lpSearchParameters, DWORD dwRecordCount)
{
	LARGE_INTEGER	li;
	DWORD			dwHighCount;
	DWORD			dwLowCount;
	DWORD			dwCenterPosition;
	DWORD			dwCenterCount;
	DWORD			dwRecordSize;
	LPBYTE			lpFileBuffer;
	BOOL			bResult;
	DWORD			dwBytesRead;
	BYTE			Signed;
	BYTE			Above;

	dwRecordSize = lpSearchParameters->SIZE_RECORD;
	lpFileBuffer = AllocateMemory(dwRecordSize);

	__asm
	{
		// Set the HighCount and LowCount for the file.
		//.............................................
		mov		dwLowCount,0
		mov		eax,dwRecordCount
		dec		eax			// Make zero based.
		mov		dwHighCount,eax
	}
	while(TRUE)
	{
		__asm
		{
			// CenterPosition = ((HighCount+LowCount)/2)*Record Size
			// +HeaderBytes.
			//......................................................
			mov		eax,dwHighCount
			add		eax,dwLowCount
			shr		eax,1
			mov		dwCenterCount,eax
			mov		ecx,dwRecordSize
			mul		ecx
			add		eax,dwHeaderBytes
			mov		dwCenterPosition,eax
		}
		// Read in the record pointer to by the CenterPosition
		// file pointer.
		//....................................................
		li.QuadPart = 0;
		li.LowPart = dwCenterPosition;
		li.QuadPart = SetMyFilePointer(lpFileName,hFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto SearchDiskEnd;
		}
		bResult = ReadMyFile(lpFileName,hFile,lpFileBuffer,dwRecordSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			li.QuadPart = -1;
			goto SearchDiskEnd;
		}

		__asm
		{
			// Compare search field in the record with the 
			// search string.
			//............................................
			mov		edx,lpSearchParameters
			mov		esi,lpSearchString
			mov		edi,lpFileBuffer

			// Point to the field in the record to compare.
			//.............................................
			add		edi,dword ptr [edx].SEARCH_OFFSET
			mov		ecx,dwSizeOfString
			cmp		ecx,dword ptr [edx].SEARCH_SIZE
			jbe		L1
			mov		ecx,dword ptr [edx].SEARCH_SIZE

			// See if the search fields are signed or not.
			//............................................
		L1:	btr		dword ptr [edx].TYPE_SEARCH,7
			setc	Signed

			// Set the direction for the comparison.
			//......................................
			cmp		dword ptr [edx].SEARCH_DIRECTION,BACKWARD
			jne		L2
			std
		L2:	cmp		dword ptr [edx].TYPE_SEARCH,0
			jne		L3
			repe	cmpsb
			jmp		L5
		L3:	cmp		dword ptr [edx].TYPE_SEARCH,1
			jne		L4
			repe	cmpsw
			jmp		L5
		L4:	cmp		dword ptr [edx].TYPE_SEARCH,2
			jne		L5
			repe	cmpsd
		L5:	cld			// Make sure.

			// Set the results according to the the type of comparison.
			//.........................................................
			pushfd
			cmp		Signed,1
			je		L6
			popfd
			seta	Above
			jmp		L7
		L6:	popfd
			setg	Above

			// Reset the signed field in the TYPE_SEARCH parameter
			// for the next record.
			//....................................................
			bts		dword ptr [edx].TYPE_SEARCH,7

			// Break if we have a match.
			//..........................
		L7:	je		HaveAMatch

			// We did not have a match. Adjust the HighCount or
			// LowCount accordingly.
			//.................................................
			mov		eax,dwCenterCount
			cmp		Above,0
			je		L9
			inc		eax
			mov		dwLowCount,eax
			cmp		eax,dwHighCount
			jbe		L8
			mov		li.LowPart,0
			mov		li.HighPart,0
			jmp		SearchDiskEnd
		L8:	jmp		L11
		L9:	sub		eax,1
			mov		dwHighCount,eax
			jc		L10
			cmp		eax,dwLowCount
			jae		L11
	   L10:	mov		li.LowPart,0
			mov		li.HighPart,0
			jmp		SearchDiskEnd
	   L11:
		}	// __asm
	}	// while(TRUE)
	HaveAMatch:

	// We had a match. Now look for the first occurance of the
	// string in the file. Adjust CenterPostion file pointer.
	//........................................................
	__asm
	{
		mov		ecx,dwHeaderBytes
		sub		dwCenterPosition,ecx
	}
	while(TRUE)
	{
		__asm
		{
			mov		eax,dwRecordSize
			mov		ecx,dwHeaderBytes
			sub		dwCenterPosition,eax
			jnc		L12
			pushfd
			add		dwCenterPosition,ecx
			popfd
			jmp		LastMatch
	   L12:	add		dwCenterPosition,ecx
		}
		// Read in the record pointer to by the CenterPosition
		// file pointer.
		//....................................................
		li.QuadPart = 0;
		li.LowPart = dwCenterPosition;
		li.QuadPart = SetMyFilePointer(lpFileName,hFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto SearchDiskEnd;
		}
		bResult = ReadMyFile(lpFileName,hFile,lpFileBuffer,dwRecordSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			li.QuadPart = -1;
			goto SearchDiskEnd;
		}

		__asm
		{
			// Compare search field in the record with the 
			// search string.
			//............................................
			mov		edx,lpSearchParameters
			mov		esi,lpSearchString
			mov		edi,lpFileBuffer

			// Point to the field in the record to compare.
			//.............................................
			add		edi,dword ptr [edx].SEARCH_OFFSET
			mov		ecx,dwSizeOfString
			cmp		ecx,dword ptr [edx].SEARCH_SIZE
			jbe		L13
			mov		ecx,dword ptr [edx].SEARCH_SIZE

			// See if the search fields are signed or not.
			//............................................
	   L13:	btr		dword ptr [edx].TYPE_SEARCH,7
			setc	Signed

			// Set the direction for the comparison.
			//......................................
			cmp		dword ptr [edx].SEARCH_DIRECTION,BACKWARD
			jne		L14
			std
	   L14:	cmp		dword ptr [edx].TYPE_SEARCH,0
			jne		L15
			repe	cmpsb
			jmp		L17
	   L15:	cmp		dword ptr [edx].TYPE_SEARCH,1
			jne		L16
			repe	cmpsw
			jmp		L17
	   L16:	cmp		dword ptr [edx].TYPE_SEARCH,2
			jne		L17
			repe	cmpsd
	   L17:	cld			// Make sure.

			// If this record did not match, or no more records to
			// match against, the previous record is our first
			// match. 
			//.....................................................
		LastMatch:
			jz		L18
			mov		eax,dwCenterPosition
			add		eax,dword ptr [edx].SIZE_RECORD
			mov		li.LowPart,TRUE
			mov		li.HighPart,eax
			jmp		SearchDiskEnd

			// Reset the signed bit if required.
			//..................................
	   L18:	cmp		Signed,0
			je		L19
			bts		dword ptr [edx].TYPE_SEARCH,7
	   L19:	mov		ecx,dwHeaderBytes
			sub		dwCenterPosition,ecx
		}	// __asm
	}	// while(TRUE)

	SearchDiskEnd:
	DeallocateMemory(lpFileBuffer);
	return(li.QuadPart);
}
